﻿"""
This is a very simple demo, but it also illustrates the use of viewpoints with
vizconnect.  

Viewpoints are a method for forcing a display to be at a particular location.
The sample viewpoint in this script places the user at the top of a balcony.

You can test the effect of setting the viewpoint by adjusting the position values
for the viewpoint at the bottom of the script
"""

import viz
import vizact
import vizconnect


# start the vizconnect session stored in the given directory
vizconnect.go("vizconnect_config.py")

# oriMode sets what the viewpoint is resetting to. For example...
# vizconnect.VIEWPOINT_MATCH_DISPLAY
# matches orientation of the display to the orientation of the viewpoint
# 
# vizconnect.VIEWPOINT_MATCH_FEET
# matches orientation of the feet to the orientation of the viewpoint
# 
# vizconnect.VIEWPOINT_MATCH_BASE
# matches orientation of the base object (transport, avatar, tracker) to the orientation of the viewpoint
#
# Similar for posMode
oriMode = vizconnect.VIEWPOINT_MATCH_DISPLAY
posMode = vizconnect.VIEWPOINT_MATCH_FEET

# Add a viewpoint.
vp = vizconnect.addViewpoint(	pos=[-13.24803, 12.28260, 8.83578],
								euler=[90, 0, 0],
								posMode=posMode,
								oriMode=oriMode,
								constant=False,
								)

# Displays are added to viewpoints, the viewpoint will traverse the scenegraph to
# determine if the display is attached to an avatar, tracker, etc in order to
# perform the requested resets.
vp.add(vizconnect.getDisplay())

# Call reset viewpoints, which forces the display into the viewpoint position.
# This function can be called as often as desired, it is currently also mapped
# onto the insert button.
vizconnect.resetViewpoints()
# add a reset key so when r is pressed the user is moved back back to the viewpoint
vizact.onkeydown('r', vizconnect.resetViewpoints)


# add an environment
viz.add('piazza.osgb')

